// Interface.cpp
// This file contains the user interface of the bootloader
#include "Interface.h"
#include <conio.h> //needed for getchar
#include <fstream> //used to read from files

//*******************************************
// function to display Main Menu
//*******************************************
void MainMenu(void)
{
	//Local variables
	int choice = 55;

	while(choice != 52)
	{
		system("CLS");//clear the screen
		printf("**********************************************\n");
		printf("*          Bootlader Interface V1.0          *\n");
		printf("**********************************************\n");
		printf("\n");
		printf(" Current Comms Interface  : ");
		if (iFace == 0)
			printf("SCI\n");
		else
			printf("CAN\n");
		if (iFace == 0)
			printf(" Current Baud Rate	  : %i\n",BaudRate);
		else
			printf(" Current Bitrate (b/s)	  : %i\n",ChannelBitrate);
		if (iFace == 0)
			printf(" Current Comms Port	  : %i\n",SCIPort);
		else
			printf(" Current Comms Port	  : %i\n",CANPort+1);
		printf("\n");
		printf("----------------------------------------------\n");
		printf("\n");
		printf(" Options:\n");
		printf("\n");
		printf(" 1: Change Comms Interface\n");
		if (iFace == 0)
			printf(" 2: Change Baud Rate\n");
		else
			printf(" 2: Change Bitrate\n");
		printf(" 3: Change Comms Port\n");
		printf(" 4: Transmit S-Records\n");
		printf("\n");
		printf(" Please make a selection (1-4):	\n");
		printf("\n");
		printf("**********************************************\n");
		choice = getch();
		while ((choice != 49) & (choice != 50) & (choice != 51) & (choice != 52))
			choice = getch();
		switch (choice)
		{
		case 49: //1
			ChangeCommsIface();
			break;

		case 50: //2
			if (iFace == 0)
				ChangeBaudRate();
			else
				ChangeBitrate();
			break;
		case 51: //3
			if (iFace == 0)
				ChangeSCIPort();
			else
				ChangeCANPort();
			break;
		case 52: //4
			system("CLS");//clear the screen
			PreTransmission();
			break;
		}
	}
}



//*******************************************
// function to display change comms interface menu
//*******************************************
void ChangeCommsIface(void)
{
	//local variable
	int choice = 55;
	
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" Select desinred communications interface:\n");
	printf("\n");
	printf(" 1: SCI\n");
	printf(" 2: CAN\n");
	printf("\n");
	printf(" Please make a selection (1-2):	\n");
	printf("\n");
	printf("**********************************************\n");
	choice = getch();
	while ((choice != 49) & (choice != 50))
		choice = getch();
	switch (choice)
	{
	case 49: //1
		iFace = 0;
		break;
	case 50: //2
		iFace = 1;
		break;
	}
}

//*******************************************
// function to display change baud rate
//*******************************************
void ChangeBaudRate(void)
{
	//local variable
	int choice = 55;
	
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" Select desired baud rate:\n");
	printf("\n");
	printf(" 1: 9600\n");
	printf(" 2: 19200\n");
	printf(" 3: 38400\n");		
	printf(" 4: 57600\n");
	printf("\n");
	printf(" Please make a selection (1-4):	\n");
	printf("\n");
	printf("**********************************************\n");
	choice = getch();
	while ((choice != 49) & (choice != 50) & (choice != 51) & (choice != 52))
		choice = getch();
	switch (choice)
	{
	case 49: //1
		BaudRate = 9600;
		break;
	case 50: //2
		BaudRate = 19200;
		break;
	case 51: //3
		BaudRate = 38400;
		break;
	case 52: //4
		BaudRate = 57600;
		break;
	}
}


//*******************************************
// function to display change bitrate
//*******************************************
void ChangeBitrate(void)
{
	//local variable
	int choice = 55;
	
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" Select desired bitrate:\n");
	printf("\n");
	printf(" 1: 50kb/s\n");
	printf(" 2: 83.3kb/s\n");
	printf(" 3: 125kb/s\n");
	printf(" 4: 500kb/s\n");
	printf(" 5: 1000kb/s\n");
	printf("\n");
	printf(" Please make a selection (1-5):	\n");
	printf("\n");
	printf("**********************************************\n");
	choice = getch();
	while ((choice != 49) & (choice != 50) & (choice != 51) & (choice != 52) & (choice !=53))
		choice = getch();
	switch (choice)
	{
	case 49: //1
		ChannelBitrate = 50000;
		break;
	case 50: //2
		ChannelBitrate = 83300;
		break;
	case 51: //3
		ChannelBitrate = 125000;
		break;
	case 52: //4
		ChannelBitrate = 500000;
		break;
	case 53: //5
		ChannelBitrate = 1000000;
		break;
	}
}

//*******************************************
// function to display change SCI port
//*******************************************
void ChangeSCIPort(void)
{
	//local variable
	int choice = 55;
	
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" Select desired comms port:\n");
	printf("\n");
	printf(" 1: COM1\n");
	printf(" 2: COM2\n");
	printf(" 3: COM3\n");
	printf(" 4: COM4\n");
	printf("\n");
	printf(" Please make a selection (1-4):	\n");
	printf("\n");
	printf("**********************************************\n");
	choice = getch();
	while ((choice != 49) & (choice != 50) & (choice != 51) & (choice != 52))
		choice = getch();
	switch (choice)
	{
	case 49: //1
		SCIPort = 1;
		break;
	case 50: //2
		SCIPort = 2;
		break;
	case 51: //3
		SCIPort = 3;
		break;
	case 52: //4
		SCIPort = 4;
		break;
	}
}


//*******************************************
// function to display change CAN port
//*******************************************
void ChangeCANPort(void)
{
	//local variable
	int choice = 55;
	
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" Select desired comms port:\n");
	printf("\n");
	printf(" 1: CAN1\n");
	printf(" 2: CAN2\n");
	printf("\n");
	printf(" Please make a selection (1-2):	\n");
	printf("\n");
	printf("**********************************************\n");
	choice = getch();
	while ((choice != 49) & (choice != 50))
		choice = getch();
	switch (choice)
	{
	case 49: //1
		CANPort = 0;
		break;
	case 50: //2
		CANPort = 1;
		break;
	}
}


//*******************************************
// function to display pretransmission message
//*******************************************
void PreTransmission(void)
{
	system("CLS");//clear the screen
	printf("**********************************************\n");
	printf("*          Bootlader Interface V1.0          *\n");
	printf("**********************************************\n");
	printf("\n");
	printf(" NOTE\n");
	printf(" ----\n");
	printf(" Ensure that the s-record of the secondary \n");
	printf(" bootloader is in the application directory.\n");
	printf("\n");
	printf(" Also confirm that the s-record of the \n");
	printf(" application to be loaded to flash is in the \n");
	printf(" application directory, contains global \n");
	printf(" addressing and is named 'application.abs.glo'\n");
    printf("\n");
	printf(" Finally, ensure that the primary bootloader \n");
	printf(" is currently executing on the MCU. \n");
	printf("\n");
	printf("\n");
	printf(" Press any key to begin transmission...\n");
	printf("\n");
	printf("**********************************************\n");
	getch();
	system("CLS");//clear the screen
}